-- DROP FUNCTION get_record_note_id;

CREATE OR REPLACE FUNCTION get_record_note_id(
    IN _dbrid                     varchar,
    IN _rcategory                 varchar DEFAULT null, -- > https://ci.prodat-sql.de/sources/tests/suite/16/runner/1053?selectedBranch=dev%2Fdsc%2F12976-20470-einkauf-puffer-bv-v24#teststep-15344
    IN _rcategory__filterout      bool    DEFAULT false, -- die in rc_category wird AUSGEFILTERT (NOT) > https://ci.prodat-sql.de/sources/tests/suite/16/runner/1053?selectedBranch=dev%2Fdsc%2F12976-20470-einkauf-puffer-bv-v24#teststep-15344
    IN _withparent                bool    DEFAULT false -- Parent => Child berücksichtigen: ABK hat auch eine Notiz der AB2
    )
    RETURNS integer
    AS $$
       SELECT rc_id
         FROM recnocomments
        WHERE (_dbrid = rc_dbrid OR (_withparent IS true AND _dbrid = rc_parent_dbrid) )
          AND xor(coalesce(rc_category, '') = coalesce(_rcategory, rc_category, ''), _rcategory__filterout)
          AND rc_wvod IS NULL
        ORDER BY rc_parent_dbrid IS null DESC/*eigene Notizen bevorzugt!*/, rc_date DESC, rc_id DESC -- Parent => Child berücksichtigen: ABK hat auch eine Notiz der AB2
         LIMIT 1;
    $$ LANGUAGE SQL STABLE PARALLEL SAFE;

/*
CREATE OR REPLACE FUNCTION get_record_note_id_txt(indbrid VARCHAR, rcategory VARCHAR DEFAULT NULL) RETURNS VARCHAR(1000) AS $$
  SELECT rc_betreff||COALESCE(' ~ '||rc_text, '')::VARCHAR(1000) FROM public.recnocomments WHERE rc_id=get_record_note_id($1, $2);
  $$ LANGUAGE SQL STABLE;
*/
-- get_record_note_id_txt(..., ..., True, False) = betreff
-- get_record_note_id_txt(..., ..., True, True)  = betreff ~ text mehrzeilig
-- get_record_note_id_txt(..., ...)              = betreff ~ text-zeile 1
-- get_record_note_id_txt(..., ..., False)       = text-zeile 1
-- get_record_note_id_txt(..., ..., False, True) = text mehrzeilig
CREATE OR REPLACE FUNCTION get_record_note_id_txt(
    IN _dbrid                    varchar,
    IN _rcategory                varchar DEFAULT null,
      --WithBetreff BOOL DEFAULT True, WithText BOOL DEFAULT True, OnlyFirstLine BOOL DEFAULT True) RETURNS VARCHAR(1000) AS $$
    IN _WithBetreff              bool    DEFAULT true,
    IN _WithText_FirstLineIsNull bool    DEFAULT null, -- TRI STATE! Null => nur erste Zeile. True > alles, False > nix
    IN _rcategory__filterout     bool    DEFAULT false -- die in rc_category wird AUSGEFILTERT (NOT)
    )
    RETURNS varchar(1000)
    AS $$
       SELECT
              concat_ws(
                ' ~ ',
                CASE WHEN _WithBetreff
                          THEN nullif( rc_betreff, langtext(1396) ) -- der Text "Informationen" ist Standard/Vorgabe für den Betreff, wenn man in der Oberfläche etwas neu einfügt
                          ELSE null
                END,
                nullif(CASE
                            --WHEN WithText AND OnlyFirstLine THEN TSystem.SL_GetLine(rc_text, 1)
                            --WHEN WithText                   THEN rc_text
                            --ELSE                                 NULL
                            WHEN _WithText_FirstLineIsNull IS NULL
                                 THEN TSystem.SL_GetLine(rc_text, 1)
                            WHEN _WithText_FirstLineIsNull
                                 THEN rc_text
                            ELSE null
                       END
                      , ''
                      )
              )::varchar(1000)
         FROM recnocomments
        WHERE rc_id = get_record_note_id(_dbrid, _rcategory, _rcategory__filterout);
    $$ LANGUAGE SQL STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION get_record_has_note(
    IN _dbrid                     varchar,
    IN _rcategory                 varchar DEFAULT NULL,
    IN _rcategory__filterout      bool    DEFAULT false, -- die in rc_category wird AUSGEFILTERT (NOT)
    IN _withparent                bool    DEFAULT false -- Parent => Child berücksichtigen: ABK hat auch eine Notiz der AB2
    )
    RETURNS boolean
    AS $$
        SELECT get_record_note_id(_dbrid, _rcategory, _rcategory__filterout, _withparent) IS NOT NULL;
    $$ LANGUAGE SQL STABLE PARALLEL SAFE;

-- Funktion zur Überprüfung ob Parent-Note einen Kommentar besitzt
CREATE OR REPLACE FUNCTION get_record_has_parent_note(
    IN _dbrid                     varchar,
    IN _rcategory                 varchar DEFAULT NULL,
    IN _rcategory__filterout      bool    DEFAULT false -- die in rc_category wird AUSGEFILTERT (NOT)
    )
    RETURNS boolean
    AS $$
        SELECT get_record_note_id((SELECT DISTINCT rc_parent_dbrid
                                     FROM recnocomments
                                    WHERE rc_dbrid = _dbrid
                                    LIMIT 1
                                  )
                                  , _rcategory
                                  , _rcategory__filterout
                                  ) IS NOT NULL;
    $$ LANGUAGE SQL STABLE PARALLEL SAFE;

-- Funktion zur Ermittlung eines Arbeitsganges (vorerst), zur Anzeige dessen im Notizassistenten.
CREATE OR REPLACE FUNCTION get_record_note_source(
    IN _dbrid varchar,
    IN _table_name varchar DEFAULT NULL
    )
    RETURNS varchar
    AS $$
    DECLARE result varchar;
    BEGIN
        IF _table_name = 'ab2' then
          SELECT lang_text(163) || a2_n
            INTO result
            FROM ab2
           WHERE dbrid = _dbrid;
        END IF;

        RETURN result;
    END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;